<?php
/* --------------------------------------------------------------
  delisprint.php 2017-12-01
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2017 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------


  based on:
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2002-2003 osCommerce(cod.php,v 1.28 2003/02/14); www.oscommerce.com
  (c) 2003	 nextcommerce (invoice.php,v 1.6 2003/08/24); www.nextcommerce.org
  (c) 2003 XT-Commerce - community made shopping http://www.xt-commerce.com ($Id: froogle.php 1188 2005-08-28 14:24:34Z matthias $)

  Released under the GNU General Public License
  --------------------------------------------------------------------------------------- */
defined('_VALID_XTC') or die('Direct Access to this location is not allowed.');

class delisprint
{
	public $code = 'delisprint';
	public $title;
	public $description;
	public $enabled;
	
	
	public function __construct()
	{
		global $order;
		
		$this->title       = defined('MODULE_DELISPRINT_TEXT_TITLE') ? MODULE_DELISPRINT_TEXT_TITLE : '';
		$this->description = defined('MODULE_DELISPRINT_TEXT_DESCRIPTION') ? MODULE_DELISPRINT_TEXT_DESCRIPTION : '';
		$this->sort_order  = defined('MODULE_DELISPRINT_SORT_ORDER') ? MODULE_DELISPRINT_SORT_ORDER : '0';
		$this->enabled     = defined('MODULE_DELISPRINT_STATUS') && MODULE_DELISPRINT_STATUS === 'True';
		$this->CAT         = [];
		$this->PARENT      = [];
	}
	
	
	public function process($file)
	{
		@ xtc_set_time_limit(0);
		
		if($_POST['oders_status'] != null)
		{
			$orders_query_where = ' WHERE orders_status="' . (int)$_POST['oders_status'] . '"';
		}
		
		$schema = ' ';
		//$schema = 'Kundennummer;Anrede;Vorname;Nachname;Firma;Straße;PLZ;Ort;Land;E-Mail;Telefon;Name L;Firma L;Straße L;Stadtteil L;PLZ L;Ort L;Bundesland L;Land L;Name R;Firma R;Straße R;Stadtteil R;PLZ R;Ort R;Bundesland R;Land R' . "\n";
		
		$orders_query = 'SELECT orders_id,
								customers_id, 
								customers_telephone,
								customers_email_address,
								delivery_name,  		
								delivery_firstname, 
								delivery_lastname, 
								delivery_company, 
								delivery_street_address, 
								delivery_house_number, 
								delivery_suburb, 
								delivery_city, 
								delivery_postcode, 
								delivery_state, 
								delivery_country, 
								delivery_country_iso_code_2, 
								payment_method, 
								comments, 
								date_purchased, 
								orders_status, 
								currency, 
								shipping_class 
							FROM orders ' . $orders_query_where;
		
		$customers_query = xtc_db_query($orders_query);
		while($customers = xtc_db_fetch_array($customers_query))
		{
			$paket       = trim($_POST['gm_paket']);
			$order_value = '';
			
			if($customers['payment_method'] === 'cod')
			{
				$cod_query         = 'SELECT text from orders_total where orders_id="' . (int)$customers['orders_id']
				                     . '" and class="ot_cod_fee"';
				$cod_query         = xtc_db_query($cod_query);
				$cod_array         = xtc_db_fetch_array($cod_query);
				$paket             .= ', NN';
				$order_value_query = 'SELECT value FROM orders_total WHERE orders_id="' . (int)$customers['orders_id']
				                     . '" AND class="ot_total"';
				$order_value_query = xtc_db_query($order_value_query);
				$order_value_array = xtc_db_fetch_array($order_value_query);
				$order_value       = round($order_value_array['value'], 2);
				$order_value       = str_replace('.', ',', $order_value);
			}
			
			$comment = preg_replace('/\s+/', ' ', $customers['comments']);
			//$order_value ?
			$cod_value = str_replace(' ' . $customers['currency'], '', $cod_array['text']);
			/*

			Schema für Delisprint 5.6.7

			$schema = '"Ref. (Adresse)";"Firma";"Name";"Zu Händen";"Adresse 1";"Adresse 2";"de";"Region";"28255";"Stadt";"Tel.";"Fax";"j.wrase@cusp.de";"Bemerkung (Adr.)"';

			 */
			
			$customerStreetAddress = isset($customers['delivery_street_address']) ? trim($customers['delivery_street_address']
			                                                                             . ' '
			                                                                             . $customers['delivery_house_number']) : '';
			
			$csvExport = [
				'address_ref' => $customers['customers_id'],
				'company'     => isset($customers['delivery_company']) ? $this->format_item($customers['delivery_company']) : '',
				'name'        => isset($customers['delivery_name']) ? $this->format_item($customers['delivery_name']) : '',
				'purpose'     => '',
				'address_1'   => $this->format_item($customerStreetAddress),
				'address_2'   => '',
				'country'     => isset($customers['delivery_country_iso_code_2']) ? $this->format_item($customers['delivery_country_iso_code_2']) : '',
				'area'        => isset($customers['delivery_country']) ? $this->format_item($customers['delivery_country']) : '',
				'post_code'   => isset($customers['delivery_postcode']) ? $this->format_item($customers['delivery_postcode']) : '',
				'town'        => isset($customers['delivery_city']) ? $this->format_item($customers['delivery_city']) : '',
				'phone'       => isset($customers['customers_telephone']) ? $this->format_item($customers['customers_telephone']) : '',
				'fax'         => '',
				'email'       => isset($customers['customers_email_address']) ? $this->format_item($customers['customers_email_address']) : '',
				'remarks'     => $this->build_remarks($customers, $paket, $cod_value, $comment)
			];
			
			$schema_entry = '';
			foreach($csvExport as $entry)
			{
				$schema_entry .= '"' . $entry . '";';
			}
			$schema_entry .= "\n";
			$schema       .= $schema_entry;
		}
		
		$schema = trim($schema);
		
		if(empty($schema))
		{
			$schema = ' ';
		}
		
		// create File
		$fp = fopen(DIR_FS_DOCUMENT_ROOT . 'export/' . $file, 'w+');
		fputs($fp, $schema);
		fclose($fp);
		
		if($_POST['oders_status_new'] != null)
		{
			$query = 'UPDATE orders SET orders_status ="' . (int)$_POST['oders_status_new'] . '"' . $orders_query_where;
			xtc_db_query($query);
		}
		
		switch($_POST['export'])
		{
			case 'yes' :
				// send File to Browser
				$extension = substr($file, -3);
				$fp        = fopen(DIR_FS_DOCUMENT_ROOT . 'export/' . $file, 'rb');
				$buffer    = fread($fp, filesize(DIR_FS_DOCUMENT_ROOT . 'export/' . $file));
				fclose($fp);
				header('Content-type: application/x-octet-stream');
				header('Content-disposition: attachment; filename=' . $file);
				echo $buffer;
				exit;
				break;
		}
	}
	
	
	public function display()
	{
		$customers_statuses_array = xtc_get_customers_statuses();
		
		// build Currency Select
		
		$orders_status_array = [
			[
				'id'   => '',
				'text' => ALL_ORDER_STATUS
			]
		];
		
		$orders_status_query = xtc_db_query('SELECT 
													orders_status_name, 
													orders_status_id 
												FROM ' . TABLE_ORDERS_STATUS . '
												WHERE language_id = "' . (int)$_SESSION['languages_id'] . '"
												ORDER BY orders_status_id');
		while($orders_status = xtc_db_fetch_array($orders_status_query))
		{
			$orders_status_array[] = [
				'id'   => $orders_status['orders_status_id'],
				'text' => $orders_status['orders_status_name'],
			];
		}
		
		$orders_status_new_array            = $orders_status_array;
		$orders_status_new_array[0]['text'] = ORDER_STATUS_NO_CHANGE;
		
		$export_values_array = [
			[
				'id'   => 'yes',
				'text' => EXPORT_YES
			],
			[
				'id'   => 'no',
				'text' => EXPORT_NO
			]
		];
		
		return [
			'text' => '<span class="options-title">' . ORDERS_STATUS . '</span><br>' . ORDERS_STATUS_DESC . '<br>'
			          . xtc_draw_pull_down_menu('oders_status', $orders_status_array) . '<br><br>'
			          . ORDERS_STATUS_NEW_DESC . '<br>' . xtc_draw_pull_down_menu('oders_status_new',
			                                                                      $orders_status_new_array) . '<br>'
			          . '<span class="options-title">' . GM_PAKET
			          . '</span><br><input type="text" name="gm_paket" value="NP" size="4" /><br>'
			          . '<span class="options-title">' . EXPORT_TYPE . '</span><br>' . EXPORT . '<br>'
			          . xtc_draw_pull_down_menu('export', $export_values_array, 'yes')
		];
	}
	
	
	public function check()
	{
		if(!isset($this->_check))
		{
			$check_query  = xtc_db_query('SELECT `value` FROM ' . TABLE_CONFIGURATION
			                             . ' WHERE `key` = "configuration/MODULE_DELISPRINT_STATUS"');
			$this->_check = xtc_db_num_rows($check_query);
		}
		
		return $this->_check;
	}
	
	
	public function install()
	{
		xtc_db_query('INSERT INTO `gx_configurations`'
		             . ' (`key`, `value`, `legacy_group_id`, `sort_order`, `type`, `last_modified`) VALUES ("configuration/MODULE_DELISPRINT_FILE", "delisprint.txt",  "6", "1", null, now())');
		xtc_db_query('INSERT INTO `gx_configurations`'
		             . ' (`key`, `value`, `legacy_group_id`, `sort_order`, `type`, `last_modified`) VALUES ("configuration/MODULE_DELISPRINT_STATUS", "True",  "6", "1", "switcher", now())');
	}
	
	
	public function remove()
	{
		xtc_db_query('DELETE FROM ' . TABLE_CONFIGURATION . ' WHERE `key` IN ("' . implode('", "',
		                                                                                               $this->keys())
		             . '")');
	}
	
	
	public function keys()
	{
		return [
			'configuration/MODULE_DELISPRINT_STATUS',
			'configuration/MODULE_DELISPRINT_FILE'
		];
	}
	
	
	public function format_item($item)
	{
		$item = str_replace('"', "'", $item);
		$item = iconv('utf-8', 'iso-8859-15', $item);
		
		return $item;
	}
	
	
	public function build_remarks($customers, $paket, $cod_value, $comment)
	{
		$remarks = '';
		$remarks .= isset($paket) ? 'Type of shipment: ' . $this->format_item($paket) . ' ' : ' ';
		$remarks .= isset($cod_value) ? 'COD amount: ' . $this->format_item($cod_value) . ' ' : ' ';
		$remarks .= isset($customers['currency']) ? 'Currency: ' . $this->format_item($customers['currency'])
		                                            . ' ' : ' ';
		$remarks .= 'Collection-Type: Bar ';
		$remarks .= isset($comment) ? 'Comment: ' . $comment . ' ' : ' ';
		
		return $remarks;
	}
}